/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SetValueUnitTest.cpp
 *
 *  Created on: Jun 27, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Fragmentation/Summation/SetValue.hpp"

#include "SetValueUnitTest.hpp"

#include <boost/assign.hpp>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace boost::assign;

/********************************************** Test classes **************************************/

enum { OTHER=2, VALUE = 4 };

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( SetValueTest );


void SetValueTest::setUp()
{
  IndexSet set;
  set += 1,2,3,4;
  indices = new IndexSet( set );
  value = new SetValue<int>(*indices, VALUE);
};


void SetValueTest::tearDown()
{
  delete value;
  delete indices;
};

/** UnitTest for constructor
 */
void SetValueTest::constructorTest()
{
  CPPUNIT_ASSERT( value != NULL );
  CPPUNIT_ASSERT_EQUAL( (int)VALUE, value->getValue() );

};

/** UnitTest for operator()
 */
void SetValueTest::operatorTest()
{
  SetValue<int> other(*indices, OTHER);

  // operator-=
  other -= *value;
  CPPUNIT_ASSERT_EQUAL( (int)OTHER - (int)VALUE, other.getValue() );
  CPPUNIT_ASSERT_EQUAL( (int)VALUE, value->getValue() );

  // operator+=
  *value -= other;
  CPPUNIT_ASSERT_EQUAL( (int)OTHER - (int)VALUE, other.getValue() );
  CPPUNIT_ASSERT_EQUAL( (int)VALUE - ((int)OTHER - (int)VALUE), value->getValue() );
};
