/*
 * SetValue.hpp
 *
 *  Created on: Jun 25, 2012
 *      Author: heber
 */

#ifndef SETVALUE_HPP_
#define SETVALUE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IndexSet.hpp"

template <class T>
class SetValue
{
public:
  SetValue(const IndexSet &_indices, const T &_value) :
    value(_value),
    indices(_indices)
  {};

  SetValue & operator+=(const SetValue &other) {
    if (indices.contains(other.indices))
      value += other.value;
    return *this;
  }

  SetValue & operator-=(const SetValue &other) {
    if (indices.contains(other.indices))
      value -= other.value;
    return *this;
  }

  const T getValue() const {
    return value;
  }

  const IndexSet& getIndexSet() const {
    return indices;
  }

protected:
  void setValue(const T& _value) {
    value = _value;
  }

  //!> value associated with this IndexSet
  T value;
private:
  //!> reference to the index set
  const IndexSet &indices;
};


#endif /* SETVALUE_HPP_ */
