/*
 * OptionTrait.hpp
 *
 *  Created on: Oct 27, 2010
 *      Author: heber
 */

#ifndef OPTIONTRAIT_HPP_
#define OPTIONTRAIT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>
#include <typeinfo>
#include <iosfwd>

namespace MoleCuilder {

/** Contains basic information for Options.
 */
class OptionTrait
{
public:
  OptionTrait(const std::string &_token, std::type_info const * const _type, const std::string &_description, const std::string &_defaultvalue = std::string(), const std::string &_shortform = std::string());
  //OptionTrait(const OptionTrait &o);
  virtual ~OptionTrait();

  // getter for the information contained
  const std::string& getDefaultValue() const;
  const std::string& getDescription() const;
  const std::string getKeyAndShortForm() const;
  const std::string& getName() const;
  const std::string& getShortForm() const;
  const std::type_info * const getType() const;
  const std::string getTypeName() const;

  // setter for information
  void setShortForm(const std::string _shortform);

  bool hasDefaultValue() const;
  bool hasShortForm() const;

protected:
  const std::string Token;
  const std::type_info* const InternalType;
  const std::string Description;
  const std::string DefaultValue;
  std::string ShortForm;
};


}

std::ostream& operator<<(std::ostream &out, const MoleCuilder::OptionTrait &t);

#endif /* OPTIONTRAIT_HPP_ */
