/*
 * ActionTraits.hpp
 *
 *  Created on: Oct 26, 2010
 *      Author: heber
 */

#ifndef ACTIONTRAITS_HPP_
#define ACTIONTRAITS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <map>

#include "Actions/OptionTrait.hpp"

namespace MoleCuilder {

/** Interface for all ActionTraits.
 * This class defines the interface, i.e. the common set of information that
 * is stored in this traits for Action classes. It also defines a set of getter
 * functions.
 *
 * Note that there are no setters. This is because the information is to be
 * given in a specialized form of the templated class ActionTrait that derives
 * from this interface.
 *
 */
class ActionTraits : public OptionTrait {
public:
  ActionTraits(const ActionTraits &_Traits);
  ActionTraits(const OptionTrait &_Traits, const std::string _MenuTitle = "", const int _MenuPosition = 0);
  explicit ActionTraits(const std::string &_token);
  virtual ~ActionTraits();

  typedef std::map< std::string, OptionTrait* > options_map;
  typedef options_map::iterator                 options_iterator;
  typedef options_map::const_iterator           options_const_iterator;

  const std::string& getMenuName() const;
  int getMenuPosition() const;

  // getter for its options
  OptionTrait const &getOption(const std::string &token) const;

  bool hasOption(const std::string &token) const;
  bool hasOptions() const;

  options_iterator getBeginIter();
  options_iterator getEndIter();
  options_const_iterator getBeginIter() const;
  options_const_iterator getEndIter() const;

protected:

  // internal information this trait contains
  std::string MenuTitle;
  int MenuPosition;
  options_map Options;
};

/* Templated class for ActionTraits to specialize.
 * I.e. every action specializes its own ActionTrait and inherits the
 * ActionTraits class as interface , e.g. Action called SuperAction:

 * ActionTrait<SuperAction> : public ActionTraits
 *
 * within the constructor of said ActionTrait<SuperAction> the specific
 * information for this derived Action class is then given.
 */
template <class T>
class ActionTrait : public ActionTraits {
public:
  ActionTrait();
  virtual ~ActionTrait();
};

}

std::ostream &operator<<(std::ostream &out, const MoleCuilder::ActionTraits &a);

#endif /* ACTIONTRAITS_HPP_ */
