/** \file helpers.hpp
 *
 * Declaration of some auxiliary functions for memory dis-/allocation and so on 
 */

#ifndef HELPERS_HPP_
#define HELPERS_HPP_

using namespace std;

#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <math.h>
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "defs.hpp"

/********************************************** helpful functions *********************************/

// taken out of TREMOLO
/*@-namechecks@*/
#ifndef __GNUC__
# undef __attribute__
# define __attribute__(x)
#endif
/*@=namechecks@*/

/* Behandelt aufgetretene Fehler. error ist der Fehlertyp(enum Errors)
   void *SpecialData ist ein untypisierter Zeiger auf Spezielle Daten zur Fehlerbehandlung.
   Man koennte auch noch einen Zeiger auf eine Funktion uebergeben */
extern void /*@exits@*/ debug(const char *output);
  //__attribute__ ((__return__));
#define debug(data) debug_in((data), __FILE__, __LINE__)

extern void /*@exits@*/ debug_in(const char *output,
    const char *file, const int line);
  //__attribute__ ((__return__));

double ask_value(const char *text);
bool check_bounds(double *x, double *cell_size);
void bound(double *b, double lower_bound, double upper_bound);
void flip(double *x, double *y);
int pot(int base, int n);
void * Malloc(size_t size, const char* output);
void * Calloc(size_t size, const char* output);
void * ReAlloc(void * OldPointer, size_t size, const char* output);
char* MallocString(size_t size, const char* output);
void Free(void ** buffer, const char* output);
char *FixedDigitNumber(const int FragmentNumber, const int digits);

/********************************************** helpful structures *********************************/

/************************************* Class Verbose & Binary *******************************/

/** Verbose is an IO manipulator, that writes tabs according to \a Verbosity level.
 */
class Verbose
{
  public:
    Verbose(int value) : Verbosity(value) { }

    ostream& print (ostream &ost) const;
  private:
    int Verbosity;
};

ostream& operator<<(ostream& ost,const Verbose& m);

/** Binary is an IO manipulator, that writes 0 and 1 according to number \a Binary.
 */
class Binary
{
  public:
    Binary(int value) : BinaryNumber(value) { }

    ostream& print (ostream &ost) const;
  private:
    int BinaryNumber;
};

ostream& operator<<(ostream& ost,const Binary& m);



#endif /*HELPERS_HPP_*/
