/*
 * lists.hpp
 *
 *  Created on: Oct 9, 2009
 *      Author: heber
 */

#ifndef LISTS_HPP_
#define LISTS_HPP_

class atom;

/******************************** Some templates for list management ***********************************/

/** Adds linking of an item to a list.
 * \param *walker
 * \return true - adding succeeded, false - error in list
 */
template <typename X> void link(X *walker, X *end)
{
  X *vorher = end->previous;
  if (vorher != 0)
    vorher->next = walker;
  end->previous = walker;
  walker->previous = vorher;
  walker->next = end;
};

/** Removes linking of an item in a list.
 * \param *walker
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> void unlink(X *walker)
{
  if (walker->next != 0)
    walker->next->previous = walker->previous;
  if (walker->previous != 0)
    walker->previous->next = walker->next;
  walker->next = 0;
  walker->previous= 0;
};

/** Adds new item before an item \a *end in a list.
 * \param *pointer   item to be added
 * \param *end  end of list
 * \return true - addition succeeded, false - unable to add item to list
 */
template <typename X>  bool add(X *pointer, X *end)
{
  if (end != 0) {
    link(pointer, end);
  } else {
    pointer->previous = 0;
    pointer->next = 0;
  }
  return true;
};

/** Finds item in list
 * \param *suche  search criteria
 * \param *start  begin of list
 * \param *end  end of list
 * \return X - if found, 0 - if not found
 */
template <typename X, typename Y> X * find(Y *suche, X *start, X *end)
{
  X *walker = start;
  while (walker->next != end) { // go through list
    walker = walker->next; // step onward beforehand
    if (*walker->sort == *suche) return (walker);
  }
  return 0;
};

/** Removes an item from the list without check.
 * \param *walker item to be removed
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> void removewithoutcheck(X *walker)
{
  if (walker != 0) {
    unlink(walker);
    delete(walker);
    walker = 0;
  }
};

/** Removes an item from the list without check.
 *  specialized for atoms, because these have to be removed from the world as well
 *  the implementation for this declaration is in lists.cpp
 * \param *walker item to be removed
 * \return true - removing succeeded, false - given item not found in list
 */
template <> void removewithoutcheck<atom>(atom *walker);

/** Removes an item from the list, checks if exists.
 * Checks beforehand if atom is really within molecule list.
 * \param *pointer   item to be removed
 * \param *start  begin of list
 * \param *end  end of list
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> bool remove(X *pointer, X *start, X *end)
{
  X *walker = find (pointer->sort, start, end);
/*  while (walker->next != pointer) { // search through list
    walker = walker->next;
    if (walker == end) return false;  // item not found in list
  }*/
  // atom found, now unlink
  if (walker != 0)
    removewithoutcheck(walker);
  else
    return false;
  return true;
};

/** Cleans the whole list.
 * \param *start begin of list
 * \param *end end of list
 * \return true - list was cleaned successfully, false - error in list structure
 */
template <typename X> bool cleanup(X *start, X *end)
{
  X *pointer = start->next;
  X *walker = 0;
  while (pointer != end) { // go through list
    walker = pointer; // mark current
    pointer = pointer->next; // step onward beforehand
    // remove walker
    removewithoutcheck(walker);
  }
  return true;
};

#endif /* LISTS_HPP_ */
