/*
 * QtMoleculeListView.hpp
 *
 *  Created on: Jan 17, 2015
 *      Author: heber
 */

#ifndef QTMOLECULELISTVIEW_HPP_
#define QTMOLECULELISTVIEW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QModelIndex>
#include <QTreeView>

#include "CodePatterns/Observer/Observer.hpp"

class QtMoleculeList;

class QtMoleculeListView : public QTreeView, public Observer
{
  Q_OBJECT

public:
  QtMoleculeListView(QWidget * _parent);
  virtual ~QtMoleculeListView();

  void setModel(QtMoleculeList *_moleculelist);

public slots:
  void rowsSelected(const QItemSelection&, const QItemSelection&);

protected:
  virtual void update(Observable *publisher);
  virtual void recieveNotification(Observable *publisher, Notification_ptr notification);
  virtual void subjectKilled(Observable *publisher);

private:
  QModelIndex setIndexToLastColumn(const QModelIndex &_index) const;

  bool selecting;
};


#endif /* QTMOLECULELISTVIEW_HPP_ */
