/*
 * QtMoleculeList.hpp
 *
 *  Created on: Jan 21, 2010
 *      Author: crueger
 */

#ifndef QTMOLECULELIST_HPP_
#define QTMOLECULELIST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QItemSelection>
#include <QtGui/QStandardItem>
#include <QtGui/QStandardItemModel>
#include <QTimer>

#include <boost/bimap.hpp>
#include <map>
#include <set>
#include <string>

#include "CodePatterns/Observer/Observer.hpp"

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include "types.hpp"

class molecule;
class MoleculeListClass;
class QtMoleculeItem;
class QtMoleculeListView;

class QtMoleculeList : public QStandardItemModel, public Observer
{
  Q_OBJECT

public:
  QtMoleculeList();
  virtual ~QtMoleculeList();

protected:
  virtual void update(Observable *publisher);
  virtual void recieveNotification(Observable *publisher, Notification_ptr notification);
  virtual void subjectKilled(Observable *publisher);

  void refill();

  QVariant headerData(int section, Qt::Orientation orientation, int role) const;

private slots:
  void moleculeChanged();
//  void visibilityChanged(QStandardItem*, int);
  void checkState();

  friend class QtMoleculeItem;

  void readdItem(QtMoleculeItem *_molitem);

signals:
  void moleculeSelected(molecule*);
  void moleculeUnSelected(molecule*);
  void moleculesVisibilityChanged(const moleculeId_t, bool);

private:

  bool changing;
  bool ChangingChildrensVisibility;
  bool list_accessing;

  //!> informs the view in regular intervals about updates
  QTimer *update_timer;

  //!> how often per second update is signalled to view
  static const unsigned int update_times_per_second;

  friend class QtMoleculeListView;

  QtMoleculeItem * MoleculeToItem(const molecule * const _mol) const;
  const molecule * const IndexToMolecule(const QModelIndex &_index) const;
  const molecule * const ItemToMolecule(const QtMoleculeItem * const _item) const;

  void addMolecule(const molecule * const _mol);
  void addGroupItem(QStandardItem *&mainitem, const std::string &_molecule_formula);
  void addMoleculeItem(QStandardItem *_groupitem, const molecule * const _mol, const std::string &molecule_formula);
  void removeItem(QtMoleculeItem * const _item);
  int setOccurrence(QStandardItem * const _groupitem);
  bool areAnyItemsDirty();
  void addToBeSetOccurrence(QStandardItem *_groupitem);

  void informDirtyState(QtMoleculeItem *_item, const QtMoleculeItem::MoveTypes _type);

  void updateItemStates();

  typedef std::map<std::string, unsigned int> FormulaVisibilityCountMap_t;
  FormulaVisibilityCountMap_t FormulaVisibilityCountMap;

  typedef std::map<std::string, QStandardItem*> FormulaTreeItemMap_t;
  //!> map of (unique) formulas in the world
  FormulaTreeItemMap_t formula;

  typedef boost::bimap<const molecule *, QtMoleculeItem*> MoleculeItemBiMap_t;
  MoleculeItemBiMap_t MoleculeItemBiMap;

  //!> callback function to hand over to items that inform about requiring update
  const QtMoleculeItem::emitDirtyState_t callback_DirtyItems;

  typedef std::set<QtMoleculeItem*> list_of_items_t;
  //!> list of items that need an update
  list_of_items_t dirtyItems;
  //!> list of items to molecule's whose formulas has changed and need to be moved
  list_of_items_t toBeMovedItems;
  //!> list of items to new molecules which need to be added
  std::vector<const molecule *> newItems;
  //!> list of items to molecules that have been removed
  std::vector<const molecule *> toBeRemovedItems;
  //!> list of group items that need update due to moved molecule items
  std::set<QStandardItem*> toBeSetOccurrenceItems;
};

#endif /* QTMOLECULELIST_HPP_ */
