/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>
#include <boost/lexical_cast.hpp>

#include "TextUI/Query/TextQuery.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "element.hpp"
#include "periodentafel.hpp"
#include "World.hpp"

using boost::lexical_cast;
using boost::bad_lexical_cast;


TextDialog::ElementsTextQuery::ElementsTextQuery(std::string title, std::string _description) :
    Dialog::ElementsQuery(title,_description)
{}

TextDialog::ElementsTextQuery::~ElementsTextQuery()
{}

bool TextDialog::ElementsTextQuery::handle() {
  std::string shorthand;
  int Z=-1;
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  std::string::iterator olditer = line.begin();
  for(string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(string(iter, olditer));
      stream >> shorthand;
      try {
        Z = lexical_cast<int>(shorthand);
        temp = World::getInstance().getPeriode()->FindElement(Z);
      } catch (bad_lexical_cast) {
        temp = World::getInstance().getPeriode()->FindElement(shorthand.c_str());
      };
      if(!temp && Z!=-1){
        std::cout << "Invalid Element" << shorthand << std::endl;
        break;
      }
      tmp.push_back(temp);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(string(olditer, line.end()));
    stream >> shorthand;
    try {
      Z = lexical_cast<int>(shorthand);
      temp = World::getInstance().getPeriode()->FindElement(Z);
    } catch (bad_lexical_cast) {
      temp = World::getInstance().getPeriode()->FindElement(shorthand.c_str());
    };
    if(!temp && Z!=-1) {
      std::cout << "Invalid Element" << shorthand << std::endl;
      tmp.push_back(temp);
    }
  }

  return (Z!=-1);
}

