/*
 * ChangeTracker.hpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#ifndef CHANGETRACKER_HPP_
#define CHANGETRACKER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CodePatterns/Observer/Observable.hpp"
#include "CodePatterns/Singleton.hpp"

/**
 * Observes the world and notifies subscribers via saveStatus if there are
 * changes to it.
 */
class ChangeTracker : public Singleton<ChangeTracker>, public Observable {
  friend class Singleton<ChangeTracker>;
public:
  void saveStatus();
  static ChangeTracker* get();
  static void destroy();

protected:
  void update(Observable *publisher);
  bool hasChanged();

private:
  bool isConsistent;

  // private constructor and destructor due to singleton
  ChangeTracker();
  virtual ~ChangeTracker();
};

#endif /* CHANGETRACKER_HPP_ */
