/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ChangeTracker.cpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/AtomObserver.hpp"
#include "CodePatterns/Singleton_impl.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/ChangeTracker.hpp"
#include "World.hpp"

/**
 * Constructor. Signs on as an observer for the World.
 */
ChangeTracker::ChangeTracker() :
  Observable("ChangeTracker"),
  isConsistent(true)
{
  World::getInstance().signOn(this);
  AtomObserver::getInstance().signOn(this);
}

/**
 * Destructor. Signs off from the World.
 */
ChangeTracker::~ChangeTracker()
{
  AtomObserver::getInstance().signOff(this);
  World::getInstance().signOff(this);
}

/**
 * With this, the World can update the change tracker's state.
 */
void ChangeTracker::update(Observable *publisher) {
  isConsistent = false;
}

/**
 * Gets whether there are non-saved changes.
 *
 * \param true if there are any changes, false otherwise
 */
bool ChangeTracker::hasChanged() {
  return !isConsistent;
}

/**
 * Tells all observers (which are the different parsers) that they are supposed
 * to save the current state.
 */
void ChangeTracker::saveStatus() {
  if (hasChanged()) {
    LOG(0, "Saving changes.");
    notifyAll();
  }
}

CONSTRUCT_SINGLETON(ChangeTracker)
