/*
 * GetNextJobIdOperation.hpp
 *
 *  Created on: Feb 16, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_GETNEXTJOBIDOPERATION_HPP_
#define FRAGMENTCONTROLLER_GETNEXTJOBIDOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>

#include "Connection.hpp"

#include "Controller/Commands/Operation.hpp"
#include "JobId.hpp"
#include "types.hpp"

/** This Operations requests number of present jobs and present results (done
 * jobs) from the server.
 *
 */
class GetNextJobIdOperation : public Operation  {
public:
  /// Constructor for class GetNextJobIdOperation.
  GetNextJobIdOperation(Connection &_connection) :
    Operation(std::string("getnextjobid"), _connection),
    nextid(JobId::IllegalJob)
  {}
  /// Destructor for class GetNextJobIdOperation
  ~GetNextJobIdOperation() {}

public:
  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when doneJobs have been received.
  void handle_ReceiveNextId(const boost::system::error_code& e);

  /// Getter for nextid
  size_t getNextId();

protected:
  /// Callback function when Operations finishes.
  void handle_FinishOperation(const boost::system::error_code& e);

  /// current jobs left to calculate and currently calculated results
  std::list<JobId_t> nextids;

  // temporary for receiving another job id
  JobId_t nextid;
};

#endif /* FRAGMENTCONTROLLER_GETNEXTJOBIDOPERATION_HPP_ */
