/*
 * VMGJob.hpp
 *
 *  Created on: Jul 12, 2012
 *      Author: heber
 */

#ifndef VMGJOB_HPP_
#define VMGJOB_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "boost/serialization/export.hpp"
#include "boost/serialization/vector.hpp"

#include "JobMarket/Jobs/FragmentJob.hpp"

#include <vector>

/** This class encapsulates a VMG Job.
 *
 *  VMGJob calculates the long-range contribution that is missed out so far in the
 *  MPQCJob where the SCF cycle is calculated. To this end
 *
 */
class VMGJob : public FragmentJob
{
public:
  /** Constructor for class VMGJob.
   *
   * @param _JobId id of the job
   * @param _begin offset of the domain
   * @param _size edge length of the cubic(!) domain
   * @param _level level is \f$2^{\text{level}}\f$ grid points
   * @param _sampled_input vector of sampled points of the grid as right-hand side
   */
  VMGJob(const JobId_t _JobId,
      const double _begin[3],
      const double _size,
      const int _level,
      const std::vector< double > &_sampled_input);
  virtual ~VMGJob();

  FragmentResult::ptr Work();

private:
  void InitVMG();

private:
  double begin[3];
  const double size;
  const int level;
  //!> contents of the input file
  const std::vector< double > sampled_input;

private:
  /** private default cstor for serialization only
   */
  VMGJob();

  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<FragmentJob>(*this);
    int i;
    for (i=0; i< 3; ++i)
      ar & begin[i];
    ar & const_cast< double &>(size);
    ar & const_cast< int &>(level);
    ar & const_cast< std::vector< double > &>(sampled_input);
  }
};

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(VMGJob)

#endif /* VMGJOB_HPP_ */
