/*
 * MPQCJob.hpp
 *
 *  Created on: Jul 10, 2012
 *      Author: heber
 */

#ifndef MPQCJOB_HPP_
#define MPQCJOB_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "boost/serialization/export.hpp"

#include "JobMarket/Jobs/FragmentJob.hpp"

#include <string>

/** This class encapsulates a MPQC Job.
 *
 */
class MPQCJob : public FragmentJob
{
public:
  MPQCJob(
      const JobId_t _JobId,
      const std::string &_inputfile,
      const double _begin[3],
      const double _size,
      const int _level);
  virtual ~MPQCJob();

  FragmentResult::ptr Work();

private:
  //!> contents of the input file
  const std::string inputfile;
  //!> offset of grid
  double begin[3];
  //!> size of grid, i.e. edge length of cubic(!) domain
  const double size;
  //!> level, i.e. \f$2^{\text{level}}\f$ grid points per axis
  const int level;

private:
  /** private default cstor for serialization only
   */
  MPQCJob();

  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<FragmentJob>(*this);
    ar & const_cast<std::string &>(inputfile);
    int i;
    for (i=0; i<3; ++i)
      ar & begin[i];
    ar & const_cast<double &>(size);
    ar & const_cast<int &>(level);
  }
};

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(MPQCJob)

#endif /* MPQCJOB_HPP_ */
