/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MPQCJob.cpp
 *
 *  Created on: Jul 10, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// otherwise BOOST_CLASS_EXPORT_IMPLEMENT has no effect
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "MPQCJob.hpp"
#include "Jobs/MPQCData.hpp"

#include <sstream>

MPQCJob::MPQCJob(
    const JobId_t _JobId,
    const std::string &_inputfile,
    const double _begin[3],
    const double _size,
    const int _level) :
  FragmentJob(_JobId),
  inputfile(_inputfile),
  size(_size),
  level(_level)
{
  for (int i=0; i<3; ++i)
    begin[i] = _begin[i];
}

MPQCJob::MPQCJob() :
  FragmentJob(JobId::IllegalJob),
  size(0.),
  level(0)
{}

MPQCJob::~MPQCJob()
{}

FragmentResult::ptr MPQCJob::Work()
{
  // instantiate empty data
  MPQCData data;
  std::stringstream returnstream;
  boost::archive::text_oarchive oa(returnstream);
  oa << data;

  // create the result
  FragmentResult::ptr ptr( new FragmentResult(getId(), returnstream.str()) );

  return ptr;
}

// we need to explicitly instantiate the serialization functions as
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_IMPLEMENT(MPQCJob)
