/*
 * InterfaceVMGJob.hpp
 *
 *  Created on: 10.06.2012
 *      Author: Frederik Heber
 */

#ifndef INTERFACEVMGJOB_HPP_
#define INTERFACEVMGJOB_HPP_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>

#include "base/interface.hpp"
#include "base/vector.hpp"

namespace VMG
{
class MGGrid;
class MGMultigrid;
}

namespace VMGInterfaces
{

class InterfaceVMGJob : public VMG::Interface
{
public:
  InterfaceVMGJob(const std::vector< double > &_sampled_input,
                 VMG::Boundary boundary, int levelMin, int levelMax,
		 const VMG::Vector &box_begin, vmg_float box_end,
		 int coarseningSteps=0, double alpha=1.6) :
    VMG::Interface(boundary, levelMin, levelMax,
		   box_begin, box_end, coarseningSteps, alpha),
		   sampled_input(_sampled_input),
		   level(levelMax)
  {}

  virtual ~InterfaceVMGJob() {}

  void ImportRightHandSide(VMG::Multigrid& multigrid);
  void ExportSolution(VMG::Grid& grid);

private:
  const std::vector< double > sampled_input;
  const int level;
};

}

#endif /* INTERFACEVMGJOB_HPP_ */
