/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * PairCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "analysis_correlation.hpp"
#include "Tesselation/boundary.hpp"
#include "linkedcell.hpp"
#include "CodePatterns/Verbose.hpp"
#include "CodePatterns/Log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AnalysisAction/PairCorrelationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "PairCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisPairCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // obtain information
  getParametersfromValueStorage();

  // execute action
  output.open(params.outputname.string().c_str());
  binoutput.open(params.binoutputname.string().c_str());
  PairCorrelationMap *correlationmap = NULL;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  if (params.periodic)
    correlationmap = PeriodicPairCorrelation(molecules, params.elements, ranges);
  else
    correlationmap = PairCorrelation(molecules, params.elements);
  OutputCorrelationMap<PairCorrelationMap>(&output, correlationmap, OutputPairCorrelation_Header, OutputPairCorrelation_Value);
  binmap = BinData( correlationmap, params.BinWidth, params.BinStart, params.BinEnd );
  OutputCorrelationMap<BinPairMap> ( &binoutput, binmap, OutputCorrelation_Header, OutputCorrelation_Value );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPairCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPairCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
