/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * PointCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "analysis_correlation.hpp"
#include "Tesselation/boundary.hpp"
#include "linkedcell.hpp"
#include "CodePatterns/Verbose.hpp"
#include "CodePatterns/Log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <cmath>
#include <iostream>
#include <string>

#include "Actions/AnalysisAction/PointCorrelationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "PointCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisPointCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // obtain information
  getParametersfromValueStorage();

  // execute action
  output.open(params.outputname.string().c_str());
  binoutput.open(params.binoutputname.string().c_str());
  cout << "Point to correlate to is  " << params.Point << endl;
  CorrelationToPointMap *correlationmap = NULL;
  for(std::vector<const element *>::iterator iter = params.elements.begin(); iter != params.elements.end(); ++iter)
    cout << "element is " << (*iter)->getSymbol() << endl;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  if (params.periodic)
    correlationmap  = PeriodicCorrelationToPoint(molecules, params.elements, &params.Point, ranges);
  else
    correlationmap = CorrelationToPoint(molecules, params.elements, &params.Point);
  OutputCorrelationMap<CorrelationToPointMap>(&output, correlationmap, OutputCorrelationToPoint_Header, OutputCorrelationToPoint_Value);
  binmap = BinData( correlationmap, params.BinWidth, params.BinStart, params.BinEnd );
  OutputCorrelationMap<BinPairMap> ( &binoutput, binmap, OutputCorrelation_Header, OutputCorrelation_Value );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPointCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPointCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
