/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CommandLineParser_ActionRegistry_ConsistencyUnitTest.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionTrait.hpp"
#include "UIElements/CommandLineUI/CommandLineParser.hpp"

#include "CommandLineParser_ActionRegistry_ConsistencyUnitTest.hpp"

using namespace MoleCuilder;

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( CommandLineParser_ActionRegistry_ConsistencyTest );


void CommandLineParser_ActionRegistry_ConsistencyTest::setUp()
{
  AR = ActionRegistry::getPointer();
  CLP = CommandLineParser::getPointer();
};


void CommandLineParser_ActionRegistry_ConsistencyTest::tearDown()
{
  CommandLineParser::purgeInstance();
  ActionRegistry::purgeInstance();
};

/** UnitTest for consistency.
 * Here, we check that for each desired menu, stored in the Actions and
 * accessible via the ActionRegistry, there is a boost::program_options
 * present in the CommandLineParser (this is not necessarily one-and-onto,
 * there might be more program_options maps).
 */
void CommandLineParser_ActionRegistry_ConsistencyTest::ConsistencyCheck()
{
  std::set <std::string> MenuNames_from_CommandLineParser;
  std::set <std::string> MenuNames_from_ActionRegistry;

  // go through all Actions and gather menu names
  for (ActionRegistry::const_iterator iter = AR->getBeginIter();
      iter != AR->getEndIter();
      ++iter) {
    const std::string &MenuName = (iter->second)->Traits.getMenuName();
    MenuNames_from_ActionRegistry.insert(MenuName);
  }

  // go through all Command line menus and gather all option names
  for (CommandLineParser::CmdParserLookupMap::const_iterator iter = CLP->CmdParserLookup.begin();
      iter != CLP->CmdParserLookup.end();
      ++iter) {
    const std::string &MenuName = (iter->first);
    MenuNames_from_CommandLineParser.insert(MenuName);
  }


  for (std::set <std::string>::const_iterator ARiter = MenuNames_from_ActionRegistry.begin();
      ARiter != MenuNames_from_ActionRegistry.end();
      ++ARiter) {
    CPPUNIT_ASSERT_MESSAGE(*ARiter
        +" cannot be found in the CommandLineParser.\n"
        +"Have you added a program_options map to CommandLineParser for this menu?",
        MenuNames_from_CommandLineParser.count(*ARiter));
  }
};
