/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CommandLineDialog.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/CommandLineDialog.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"


using namespace std;


CommandLineDialog::CommandLineDialog()
{
}

CommandLineDialog::~CommandLineDialog()
{
}


void CommandLineDialog::queryEmpty(const char* title, string _description){
  registerQuery(new EmptyCommandLineQuery(title, _description));
}

void CommandLineDialog::queryInt(const char* title, string _description){
  registerQuery(new IntCommandLineQuery(title, _description));
}

void CommandLineDialog::queryInts(const char* title, string _description){
  registerQuery(new IntsCommandLineQuery(title, _description));
}

void CommandLineDialog::queryUnsignedInt(const char* title, string _description){
  registerQuery(new UnsignedIntCommandLineQuery(title, _description));
}

void CommandLineDialog::queryUnsignedInts(const char* title, string _description){
  registerQuery(new UnsignedIntsCommandLineQuery(title, _description));
}

void CommandLineDialog::queryBoolean(const char* title, string _description){
  registerQuery(new BooleanCommandLineQuery(title, _description));
}

void CommandLineDialog::queryDouble(const char* title, string _description){
  registerQuery(new DoubleCommandLineQuery(title, _description));
}

void CommandLineDialog::queryDoubles(const char* title, string _description){
  registerQuery(new DoublesCommandLineQuery(title, _description));
}

void CommandLineDialog::queryString(const char* title, string _description){
  registerQuery(new StringCommandLineQuery(title, _description));
}

void CommandLineDialog::queryStrings(const char* title, string _description){
  registerQuery(new StringsCommandLineQuery(title, _description));
}

void CommandLineDialog::queryAtom(const char* title, string _description) {
  registerQuery(new AtomCommandLineQuery(title, _description));
}

void CommandLineDialog::queryAtoms(const char* title, string _description) {
  registerQuery(new AtomsCommandLineQuery(title, _description));
}

void CommandLineDialog::queryMolecule(const char* title, string _description) {
  registerQuery(new MoleculeCommandLineQuery(title, _description));
}

void CommandLineDialog::queryMolecules(const char* title, string _description) {
  registerQuery(new MoleculesCommandLineQuery(title, _description));
}

void CommandLineDialog::queryVector(const char* title, bool check, string _description) {
  registerQuery(new VectorCommandLineQuery(title,check, _description));
}

void CommandLineDialog::queryVectors(const char* title, bool check, string _description) {
  registerQuery(new VectorsCommandLineQuery(title,check, _description));
}

void CommandLineDialog::queryBox(const char* title, string _description) {
  registerQuery(new BoxCommandLineQuery(title,_description));
}

void CommandLineDialog::queryElement(const char* title, string _description){
  registerQuery(new ElementCommandLineQuery(title, _description));
}

void CommandLineDialog::queryElements(const char* title, string _description){
  registerQuery(new ElementsCommandLineQuery(title, _description));
}

void CommandLineDialog::queryFile(const char* title, string _description){
  registerQuery(new FileCommandLineQuery(title, _description));
}

void CommandLineDialog::queryRandomNumberDistribution_Parameters(const char* title, string _description){
  registerQuery(new RandomNumberDistribution_ParametersCommandLineQuery(title, _description));
}

/************************** Query Infrastructure ************************/
/*       ---> shifted to folder Query                                   */
/************************************************************************/
