/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DepthFirstSearchAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "Graph/BondGraph.hpp"
#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Graph/CyclicStructureAnalysis.hpp"
#include "Graph/DepthFirstSearchAnalysis.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/GraphAction/DepthFirstSearchAction.hpp"

// and construct the stuff
#include "DepthFirstSearchAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr GraphDepthFirstSearchAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Depth-First-Search Analysis." << endl);
  atom **ListOfAtoms = NULL;
  std::deque<bond *> *LocalBackEdgeStack = NULL;
  DepthFirstSearchAnalysis DFS;
  DFS();
  DFS.UpdateMoleculeStructure();
  MoleculeLeafClass *Subgraphs = DFS.getMoleculeStructure();
  if (Subgraphs != NULL) {
    int FragmentCounter = 0;
    while (Subgraphs->next != NULL) {
      Subgraphs = Subgraphs->next;
      ListOfAtoms = NULL;
      Subgraphs->Leaf->FillListOfLocalAtoms(ListOfAtoms, Subgraphs->Leaf->getAtomCount());
      LocalBackEdgeStack = new std::deque<bond *>; // no need to have it Subgraphs->Leaf->BondCount size
      DFS.PickLocalBackEdges(ListOfAtoms, LocalBackEdgeStack);
      CyclicStructureAnalysis CycleAnalysis;
      CycleAnalysis(LocalBackEdgeStack);
      delete(LocalBackEdgeStack);
      Subgraphs->Leaf = NULL;
      delete(Subgraphs->previous);
      delete[](ListOfAtoms);  // allocated by FillListOfLocalAtoms
      FragmentCounter++;
    }
    Subgraphs->Leaf = NULL;
    delete(Subgraphs);
  }
  return Action::success;
}

Action::state_ptr GraphDepthFirstSearchAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr GraphDepthFirstSearchAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool GraphDepthFirstSearchAction::canUndo() {
  return true;
}

bool GraphDepthFirstSearchAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
