/*
 * PdbParser.hpp
 *
 *  Created on: Aug 17, 2010
 *      Author: heber
 */

#ifndef PDBPARSER_HPP_
#define PDBPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "FormatParser.hpp"
#include "FormatParserTrait.hpp"
#include "FormatParserInterface.hpp"
#include "FormatParser_common.hpp"
#include "ParserTypes.hpp"

#include "PdbAtomInfoContainer.hpp"
#include "PdbKey.hpp"

class molecule;

// declaration of specialized FormatParserTrait
template<>
struct FormatParserTrait<pdb>
{
  //!> Name of the parser
  static const std::string name;
  //!> suffix of the files the parser understands to read and write
  static const std::string suffix;
  //!> ParserTypes enumeration for the parser
  static const enum ParserTypes type;
};

/**
 * Loads a PDB format 3.2 file into the World and saves the World as a PDB file.
 */
template <>
class FormatParser< pdb >  : virtual public FormatParserInterface, public FormatParser_common
{
public:
  FormatParser();
  virtual ~FormatParser();
  void load(std::istream* file);
  void save(std::ostream* file, const std::vector<atom *> &atoms);

  bool operator==(const FormatParser< pdb>& b) const;
  void printAtomInfo(const atom *newAtom) const;

protected:
  void AtomInserted(atomId_t);
  void AtomRemoved(atomId_t);

private:
  enum PdbKey::KnownTokens getToken(string &line);
  void readAtomDataLine(const unsigned int _step, string &line, molecule *newmol);
  void parseAtomDataKeysLine(string line, int offset);
  void readNeighbors(const unsigned int _step, std::string &line);
//  void adaptImprData();
//  void adaptTorsion();
//  std::string adaptIdDependentDataString(std::string data);
  bool isUsedField(std::string fieldName);
  void writeNeighbors(std::ostream* file, int numberOfNeighbors, atom* currentAtom);
  void saveLine(ostream* file, const PdbAtomInfoContainer &atomInfo);

  // internal getter and setter
  bool isPresentadditionalAtomData(unsigned int _id);
  PdbAtomInfoContainer& getadditionalAtomData(atom *_atom);

  // internal helper functions
  atom* getAtomToParse(std::string id_string);
  void readPdbAtomInfoContainer(PdbAtomInfoContainer &atomInfo, std::string &line) const;

  /**
   * argh, why can't just PdbKey::X+(size_t)i
   */
  std::map<size_t, PdbKey::PdbDataKey> PositionEnumMap;

  /**
   * Map to associate the known keys with numbers.
   */
  std::map<std::string, PdbKey::KnownTokens> knownTokens;

  /**
   * Data which is currently not stored in atoms but was provided by the input
   * file.
   */
  std::map<size_t, PdbAtomInfoContainer> additionalAtomData;

  /**
   * Default additional atom data.
   */
  PdbAtomInfoContainer defaultAdditionalData;
};

#endif /* PDBPARSER_HPP_ */
