/*
 * FormatParser_common_common.hpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#ifndef FORMATPARSER_COMMON_HPP_
#define FORMATPARSER_COMMON_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <map>

#include "CodePatterns/Observer/Observer.hpp"
#include "FormatParserInterface.hpp"
#include "FormatParser_Parameters.hpp"
#include "types.hpp"

namespace MoleCuilder {
  class MoleculeLoadAction;
}

/**
 * This class encapsulates everything that all specialized FormatParser variants
 * have in common.
 *
 * This is because template classes cannot be partially specialization in a few
 * functions. Hence, we place all stuff that is common into a separate class.
 */
class FormatParser_common : public Observer, virtual public FormatParserInterface 
{
  friend class MoleCuilder::MoleculeLoadAction;
public:
  FormatParser_common(FormatParser_Parameters *_parameters);
  virtual ~FormatParser_common();
  void setOstream(std::ostream* file);

protected:
  void update(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);
  void subjectKilled(Observable *publisher);

  // these functions are called when atoms are inserted or removed
  virtual void AtomInserted(atomId_t) {};
  virtual void AtomRemoved(atomId_t) {};

  // functions to add atoms and bonds with ids relative to the parsed file
  void resetIdAssociations();
  void associateLocaltoGlobalId(const int local, const int global);
  int getGlobalId(const int local) const;
  int getLocalId(const int global) const;

private:
  //!> Output stream to write to when save() is called.
  std::ostream* saveStream;

  //!> typedef for atomic id-to-id map
  typedef std::map<int, int> IdtoIdMap;

  //!> Maps original atom IDs received from the parsed file to atom IDs in the world.
  IdtoIdMap LocaltoGobalIdMap;

  //!> Maps atom IDs in the World to those received from the parsed file.
  IdtoIdMap GlobaltoLocalIdMap;
};

#endif /* FORMATPARSER_COMMON_HPP_ */
