/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RotateToPrincipalAxisSystemAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Line.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "element.hpp"
#include "molecule.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "Actions/MoleculeAction/RotateToPrincipalAxisSystemAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "RotateToPrincipalAxisSystemAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeRotateToPrincipalAxisSystemAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Converting to prinicipal axis system." << endl);

    RealSpaceMatrix InertiaTensor = mol->getInertiaTensor();

    mol->RotateToPrincipalAxisSystem(params.Axis);

    // summing anew for debugging (resulting matrix has to be diagonal!)
    InertiaTensor = mol->getInertiaTensor();
  }
  return Action::success;
}

Action::state_ptr MoleculeRotateToPrincipalAxisSystemAction::performUndo(Action::state_ptr _state) {
//  MoleculeRotateToPrincipalAxisSystemState *state = assert_cast<MoleculeRotateToPrincipalAxisSystemState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeRotateToPrincipalAxisSystemAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool MoleculeRotateToPrincipalAxisSystemAction::canUndo() {
  return true;
}

bool MoleculeRotateToPrincipalAxisSystemAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
