/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MolecularDynamicsAction.cpp
 *
 *  Created on: Jun 14, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Chronos.hpp"

#include "Actions/FragmentationAction/AnalyseFragmentationResultsAction.hpp"
#include "Actions/FragmentationAction/FragmentationAutomationAction.hpp"
#include "Actions/FragmentationAction/MolecularDynamicsAction.hpp"
#include "Actions/MoleculeAction/VerletIntegrationAction.hpp"
#include "Actions/ActionQueue.hpp"
#include "Actions/ActionSequence.hpp"

#include "Descriptors/AtomDescriptor.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "MolecularDynamicsAction.def"
#include "MakroAction_impl_pre.hpp"
/** =========== define the function ====================== */

// static instances
ActionSequence FragmentationMolecularDynamicsAction::prototype_actions;
bool FragmentationMolecularDynamicsAction::isPrepared = false;

void FragmentationMolecularDynamicsAction::prepare(ActionRegistry &AR)
{
  // perform a verlet-integration first, if there are already forces or velocities
  // present. If not, we still copy the position cleanly into a new step where then
  // forces are set according to summed fragmentary contributions. This is much cleaner.
  prototype_actions.addAction(AR.getActionByName(std::string("verlet-integration")));
  prototype_actions.addAction(AR.getActionByName(std::string("output")));
  prototype_actions.addAction(AR.getActionByName(std::string("clear-fragment-results")));
  prototype_actions.addAction(AR.getActionByName(std::string("destroy-adjacency")));
  prototype_actions.addAction(AR.getActionByName(std::string("create-adjacency")));
  prototype_actions.addAction(AR.getActionByName(std::string("correct-bonddegree")));
  prototype_actions.addAction(AR.getActionByName(std::string("update-molecules")));
  prototype_actions.addAction(AR.getActionByName(std::string("fragment-molecule")));
  prototype_actions.addAction(AR.getActionByName(std::string("fragment-automation")));
  prototype_actions.addAction(AR.getActionByName(std::string("analyse-fragment-results")));
  isPrepared = true;
}

void FragmentationMolecularDynamicsAction::unprepare(ActionRegistry &AR)
{
  // empty sequence
  while (prototype_actions.removeLastAction() != NULL);
  isPrepared = false;
}

ActionState::ptr FragmentationMolecularDynamicsAction::performCall(){

  // set number of steps
  setLoop(params.steps.get());
  // remove output from sequence if not desired.
  if (!params.DoOutput.get()) {
#ifndef NDEBUG
    bool status =
#endif
        removeAction(std::string("output"));
    ASSERT( status,
        "FragmentationMolecularDynamicsAction::performCall() - output not found in ActionSequence.");
  }
  // don't recreate bond graph if not desired
  if (params.DontCreateGraphEachStep.get()) {
#ifndef NDEBUG
    bool status = true;
    status &=
#endif
        removeAction(std::string("destroy-adjacency"));

#ifndef NDEBUG
    status &=
#endif
        removeAction(std::string("create-adjacency"));

#ifndef NDEBUG
    status &=
#endif
        removeAction(std::string("correct-bonddegree"));

#ifndef NDEBUG
    status &=
#endif
        removeAction(std::string("update-molecules"));
    ASSERT( status,
        "FragmentationStructuralOptimizationAction::performCall() - at least one graph action not found in ActionSequence.");
  }
  // and call
  ActionState::ptr state(MakroAction::performCall());

  return state;
}

ActionState::ptr FragmentationMolecularDynamicsAction::performUndo(ActionState::ptr _state) {
  ActionState::ptr state(MakroAction::performUndo(_state));

  return state;
}

ActionState::ptr FragmentationMolecularDynamicsAction::performRedo(ActionState::ptr _state){
  ActionState::ptr state(MakroAction::performRedo(_state));

  return state;
}

bool FragmentationMolecularDynamicsAction::canUndo(){
  return true;
}

bool FragmentationMolecularDynamicsAction::shouldUndo(){
  return true;
}
