/*
 * UIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */


#include <cassert>
#include "Patterns/Singleton_impl.hpp"
#include "UIElements/UIFactory.hpp"

// all factories that can be used:
#include "UIElements/TextUIFactory.hpp"
#ifdef USE_GUI_QT
#include "UIElements/QT4/QTUIFactory.hpp"
#endif

UIFactory::UIFactory()
{
  // TODO Auto-generated constructor stub

}

UIFactory::~UIFactory()
{
  // TODO Auto-generated destructor stub
}

void UIFactory::makeUserInterface(InterfaceTypes type) {
  switch(type) {
    case Text :
      setInstance(new TextUIFactory());
      break;
#ifdef USE_GUI_QT
    case QT4 :
      setInstance(new QTUIFactory());
      break;
#endif
    default:
      assert(0 && "No such Factory in stock");
      break;
  }
}

CONSTRUCT_SINGLETON(UIFactory)
