/*
 * TextDialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef TEXTDIALOG_HPP_
#define TEXTDIALOG_HPP_

#include <string>

#include "UIElements/Dialog.hpp"

class TextDialog : public Dialog
{
public:
  TextDialog();
  virtual ~TextDialog();

  virtual void queryInt(const char *, int *);
  virtual void queryString(const char*, std::string *);
  virtual void queryDouble(const char*, double*);
  virtual void queryMolecule(const char*,molecule**,MoleculeListClass*);
  virtual void queryVector(const char*,Vector *,const double * const,bool);
  virtual void queryElement(const char*,element **);

protected:
  // specialized stuff for text queries
  class IntTextQuery : public Dialog::IntQuery {
  public:
    IntTextQuery(std::string title, int *_target);
    virtual ~IntTextQuery();
    virtual bool handle();
  };

  class DoubleTextQuery : public Dialog::DoubleQuery {
  public:
    DoubleTextQuery(std::string title, double *_target);
    virtual ~DoubleTextQuery();
    virtual bool handle();
  };

  class StringTextQuery : public Dialog::StringQuery {
  public:
    StringTextQuery(std::string title, std::string *_target);
    virtual ~StringTextQuery();
    virtual bool handle();
  };

  class MoleculeTextQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeTextQuery(std::string title, molecule **_target, MoleculeListClass *_molecules);
    virtual ~MoleculeTextQuery();
    virtual bool handle();
  };

  class VectorTextQuery : public Dialog::VectorQuery {
  public:
    VectorTextQuery(std::string title,Vector *_target,const double *const _cellSize,bool _check);
    virtual ~VectorTextQuery();
    virtual bool handle();
  };

  class ElementTextQuery : public Dialog::ElementQuery {
  public:
    ElementTextQuery(std::string title, element **_target);
    virtual ~ElementTextQuery();
    virtual bool handle();
  };
};

#endif /* TEXTDIALOG_HPP_ */
