/*
 * QTUIFactory.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#include <iostream>
#include <cassert>

using namespace std;

#include <qapplication.h>

#include "UIElements/QT4/QTUIFactory.hpp"
#include "UIElements/QT4/QTMainWindow.hpp"
#include "UIElements/QT4/QTDialog.hpp"
#include "version.h"
#include "defs.hpp"

QTUIFactory::QTUIFactory()
{
  // For now we just fake the command line parameters to make QT happy
  argc=1;
  argv = new char*[1];
  argv[0] = new char[256];
  strcpy(argv[0],ESPACKVersion);
  app = new QApplication(argc,argv);
}

QTUIFactory::~QTUIFactory()
{
  delete app;
  delete [] argv[0];
  delete [] argv;
}

Dialog* QTUIFactory::makeDialog() {
  return new QTDialog();
}

MainWindow* QTUIFactory::makeMainWindow(menuPopulaters populaters,MoleculeListClass *molecules, config *configuration, periodentafel *periode, char *ConfigFileName) {
  return new QTMainWindow(populaters,molecules,configuration,periode,ConfigFileName,app);
}
