/*
 * QTMainWindow.hpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#ifndef QTMAINWINDOW_HPP_
#define QTMAINWINDOW_HPP_

#include "UIElements/MainWindow.hpp"
#include <QtGui/QMainWindow>

class QTWorldView;
class StringView;
class QTMenu;
class GLMoleculeView;
class QTMoleculeView;
class QTStatusBar;

class QTMainWindow : public QMainWindow, public MainWindow
{
  Q_OBJECT

public:
  QTMainWindow(menuPopulaters populaters,MoleculeListClass *molecules, config *configuration,
               periodentafel *periode, char *ConfigFileName, QApplication *_theApp);
  virtual ~QTMainWindow();

  virtual void display();

private:
  // All kinds of QTStuff used in this window
  QApplication *theApp;
  QTWorldView *worldDisplay;
  QTMenu *editMoleculesMenu;
  GLMoleculeView *molecule3dDisplay;
  QTMoleculeView *moleculeDisplay;
  QTStatusBar *statusBar;

};

#endif /* QTMAINWINDOW_HPP_ */
