/*
 * QTMainWindow.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#include "QTMainWindow.hpp"

#include<Qt/qapplication.h>
#include<Qt/qlabel.h>
#include<Qt/qstring.h>
#include<Qt/qmenubar.h>
#include<Qt/qsplitter.h>

#include<iostream>
#include<boost/bind.hpp>

#include "atom.hpp"
#include "molecule.hpp"
#include "Menu/QT4/QTMenu.hpp"
#include "Views/QT4/QTWorldView.hpp"
#include "Views/QT4/GLMoleculeView.hpp"
#include "Views/QT4/QTMoleculeView.hpp"
#include "Views/QT4/QTStatusBar.hpp"


using namespace std;

QTMainWindow::QTMainWindow(menuPopulaters populaters,MoleculeListClass *molecules, config *configuration, periodentafel *periode, char *ConfigFileName,QApplication *_theApp) :
    theApp(_theApp)
{
  QSplitter *splitter1 = new QSplitter (Qt::Horizontal, this );
  QSplitter *splitter2 = new QSplitter (Qt::Vertical, splitter1 );

  worldDisplay = new QTWorldView(molecules,splitter2);

  moleculeDisplay = new QTMoleculeView();
  molecule3dDisplay = new GLMoleculeView();

  setCentralWidget(splitter1);
  splitter1->addWidget(splitter2);
  splitter1->addWidget(moleculeDisplay);
  splitter2->addWidget(molecule3dDisplay);
  splitter2->addWidget(worldDisplay);

  statusBar = new QTStatusBar(this);
  setStatusBar(statusBar);

  editMoleculesMenu = new QTMenu("Edit Molecules");
  populaters.MakeEditMoleculesMenu(editMoleculesMenu,molecules,configuration,periode);
  menuBar()->addMenu(editMoleculesMenu);

  connect(worldDisplay,SIGNAL(moleculeSelected(molecule*)),moleculeDisplay,SLOT(moleculeSelected(molecule*)));
  connect(worldDisplay,SIGNAL(moleculeUnSelected(molecule*)),moleculeDisplay,SLOT(moleculeUnSelected(molecule*)));
}

QTMainWindow::~QTMainWindow()
{}

void QTMainWindow::display() {
  this->show();
  theApp->exec();
}
