/*
 * logunittest.cpp
 */


using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "logunittest.hpp"
#include "log.hpp"
#include "defs.hpp"
#include "verbose.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( LogTest );


void LogTest::setUp()
{
};

void LogTest::tearDown()
{
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/**
 * UnitTest for log()
 */
void LogTest::logTest()
{
  logger::getInstance().setVerbosity(2);
  Log() << Verbose(0) << "Verbosity level is set to 2." << endl;
  Log() << Verbose(0) << "Test level 0" << endl;
  Log() << Verbose(1) << "Test level 1" << endl;
  Log() << Verbose(2) << "Test level 2" << endl;
  Log() << Verbose(3) << "Test level 3" << endl;
  Log() << Verbose(4) << "Test level 4" << endl;

  Log() << Verbose(0) << "Output a log message." << endl;
  eLog() << Verbose(0) << "Output an error message." << endl;
  setVerbosity(3);
  Log() << Verbose(4) << "This should not be printed." << endl;
  eLog() << Verbose(4) << "This should not be printed." << endl;
};
