#include "Actions/small_actions.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"

#include "atom.hpp"
#include "molecule.hpp"

/****** ChangeMoleculeNameAction *****/

char ChangeMoleculeNameAction::NAME[] = "Change filename of Molecule";

ChangeMoleculeNameAction::ChangeMoleculeNameAction(MoleculeListClass *_molecules) :
  Action(NAME),
  molecules(_molecules)
{}

ChangeMoleculeNameAction::~ChangeMoleculeNameAction()
{}

void ChangeMoleculeNameAction::call() {
  string filename;
  molecule *mol = NULL;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryMolecule("Enter index of molecule: ",&mol,molecules);
  dialog->queryString("Enter name: ",&filename);
  if(dialog->display()) {
    mol->setName(filename);
  }

  delete dialog;
}

void ChangeMoleculeNameAction::undo() {

}

bool ChangeMoleculeNameAction::canUndo() {
  return false;
}

bool ChangeMoleculeNameAction::shouldUndo() {
  return true;
}

const string ChangeMoleculeNameAction::getName() {
  return NAME;
}
