/*
 * MPQCJob.hpp
 *
 *  Created on: Feb 05, 2012
 *      Author: heber
 */

#ifndef MPQCCOMMANDJOB_HPP_
#define MPQCCOMMANDJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Results/FragmentResult.hpp"
#include "Jobs/SystemCommandJob.hpp"

#include "Jobs/MPQCCommandJob_MPQCData.hpp"

class MPQCCommandJobTest;

/** This class calls mpqc for solving a specific Hartree Fock problem.
 *
 */
class MPQCCommandJob : public SystemCommandJob
{
  //!> grant unit test access
  friend class MPQCCommandJobTest;
public:
  MPQCCommandJob(const std::string _inputfile, const JobId_t _JobId);
  ~MPQCCommandJob();

private:
  //!> class that contains energy and forces and serialization capabilities
  MPQCData data;

  FragmentResult::ptr extractResult(const std::string &resultstring);
  static const std::string keyword_energy;
  static const std::string keyword_forces;
};


#endif /* MPQCCOMMANDJOB_HPP_ */
