/*
 * UIFactory.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef UIFACTORY_HPP_
#define UIFACTORY_HPP_

class MainWindow;
class Dialog;

class UIFactory
{

public:
  enum InterfaceTypes {Text};
  virtual ~UIFactory();

  // methods for creating UIElements
  virtual MainWindow* makeMainWindow()=0;
  virtual Dialog* makeDialog()=0;

protected:
  UIFactory();

// singleton stuff
private:
  static UIFactory *theFactory;

public:
  static void makeUserInterface(InterfaceTypes type);
  static UIFactory* get();
  static void purgeInstance();
};

#endif /* UIFACTORY_HPP_ */
