/*
 * MakroAction.hpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

#ifndef MAKROACTION_HPP_
#define MAKROACTION_HPP_

#include <string>

#include "Actions/Action.hpp"

class ActionSequence;

/**
 * Action to allow producing bigger Actions from sequences of small actions.
 *
 * Destruction of the Actions and the sequence is handled by this class.
 */
class MakroAction : public Action
{
public:
  MakroAction(std::string _name,ActionSequence* _actions,bool _doRegister=true);
  virtual ~MakroAction();

  virtual void call();
  virtual void undo();
  virtual bool canUndo();

private:
  ActionSequence *actions;
};

#endif /* MAKROACTION_HPP_ */
