/*
 * ActionRegistry.hpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#ifndef ACTIONREGISTRY_HPP_
#define ACTIONREGISTRY_HPP_

#include <string>
#include <map>

class Action;

class ActionRegistry
{
public:
  Action* getActionByName(const std::string);
  void registerAction(Action*);

private:
  std::map<const std::string,Action*> actionMap;

// singleton stuff
public:
  static ActionRegistry* getRegistry();
  static void purgeRegistry();
private:
  ActionRegistry();
  virtual ~ActionRegistry();
  static ActionRegistry *theInstance;
};

#endif /* ACTIONREGISTRY_HPP_ */
