/*
 * ActionRegistry.cpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#include "Actions/ActionRegistry.hpp"
#include "Actions/Action.hpp"

#include <string>
#include <cassert>
#include <iostream>

using namespace std;

ActionRegistry *ActionRegistry::theInstance=0;

ActionRegistry::ActionRegistry()
{
  // TODO Auto-generated constructor stub

}

ActionRegistry::~ActionRegistry()
{
  // TODO Auto-generated destructor stub
}

Action* ActionRegistry::getActionByName(const std::string name){
  map<const string,Action*>::iterator iter;
  iter = actionMap.find(name);
  assert(iter!=actionMap.end() && "Query for an action not stored in registry");
  return iter->second;
}

void ActionRegistry::registerAction(Action* action){
  pair<map<const string,Action*>::iterator,bool> ret;
  ret = actionMap.insert(pair<const string,Action*>(action->getName(),action));
  assert(ret.second && "Two actions with the same name added to registry");
}

// singleton stuff
ActionRegistry* ActionRegistry::getRegistry(){
  if(!theInstance){
    theInstance = new ActionRegistry();
  }
  return theInstance;
}

void ActionRegistry::purgeRegistry(){
  if(theInstance){
    delete theInstance;
    theInstance = 0;
  }
}
