/*
 * Action.h
 *
 *  Created on: Dec 8, 2009
 *      Author: crueger
 */

#ifndef ACTION_H_
#define ACTION_H_

#include <string>

/**
 * Base class for all actions.
 *
 * Actions describe something that has to be done.
 * Actions can be passed around, stored, performed and undone (Command-Pattern).
 *
 * TODO: Add queues of actions that have been performed to allow easy implementation of multiple-step undo
 */
class Action
{
protected:
public:
  Action(std::string _name,bool _doRegister=true);
  virtual ~Action();

  virtual void call()=0;
  virtual void undo()=0;
  virtual bool canUndo()=0;

  virtual const std::string getName();

private:
  std::string name;
};

#endif /* ACTION_H_ */
