/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinkedCell_ViewStub.cpp
 *
 *  Created on: Nov 29, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "LinkedCell/LinkedCell_View.hpp"
#include "LinkedCell/LinkedCell_View_ModelWrapper.hpp"

using namespace LinkedCell;

LinkedCell_View::LinkedCell_View(const LinkedCell_Model &_LC) :
    LC( new LinkedCell_View_ModelWrapper(&_LC) )
{}

LinkedCell_View::LinkedCell_View(const LinkedCell_View &_view) :
    LC( new LinkedCell_View_ModelWrapper(_view.LC->getModel()) )
{}

LinkedCell_View::~LinkedCell_View()
{
}
