/*
 * atom_trajectoryparticleinfo.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_TRAJECTORYPARTICLEINFO_HPP_
#define ATOM_TRAJECTORYPARTICLEINFO_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include "vector.hpp"
#include "VectorSet.hpp"

/********************************************** declarations *******************************/

class TrajectoryParticleInfo {
public:
  struct
  {
    VectorSet<vector<Vector> > R;  //!< position vector
    VectorSet<vector<Vector> > U;  //!< velocity vector
    VectorSet<vector<Vector> > F;  //!< last force vector
  } Trajectory;
  int FixedIon;   //!< config variable that states whether forces act on the ion or not

  TrajectoryParticleInfo();
  ~TrajectoryParticleInfo();

private:
};

#endif /* ATOM_TRAJECTORYPARTICLEINFO_HPP_ */
