/*
 * QtMoleculeItem_visibility.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_VISIBILITY_HPP_
#define QTMOLECULEITEM_VISIBILITY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

class QtMoleculeItemFactory;

/** This class contains the visibility of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_visibility : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_visibility(
      QtObservedMolecule::ptr &_ObservedMolecule,
      const emitDirtyState_t &_emitDirtyState) :
        QtMoleculeItem(_ObservedMolecule, QtMoleculeItem::DoesNotMove, _emitDirtyState)
  {
    setFlags(flags() | Qt::ItemIsUserCheckable);
    setCheckState(Qt::Unchecked);
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's visibility.
   *
   */
  void internal_updateState()
  {}

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::VISIBILITY; }
};



#endif /* QTMOLECULEITEM_VISIBILITY_HPP_ */
