/*
 * QtMoleculeItem_occurrence.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_OCCURRENCE_HPP_
#define QTMOLECULEITEM_OCCURRENCE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

class QtMoleculeItemFactory;

/** This class contains the occurrence of a molecule.
 *
 */
class QtMoleculeItem_occurrence : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_occurrence(
      QtObservedMolecule::ptr &_ObservedMolecule,
      const emitDirtyState_t &_emitDirtyState) :
        QtMoleculeItem(_ObservedMolecule, QtMoleculeItem::DoesNotMove, _emitDirtyState)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's occurrence.
   *
   */
  void internal_updateState()
  {
    setText(QString(""));
  }

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::OCCURRENCE; }
};



#endif /* QTMOLECULEITEM_OCCURRENCE_HPP_ */
