/*
 * QtMoleculeItem_atomcount.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_ATOMCOUNT_HPP_
#define QTMOLECULEITEM_ATOMCOUNT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

class QtMoleculeItemFactory;

/** This class contains the atomcount of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_atomcount : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_atomcount(
      QtObservedMolecule::ptr &_ObservedMolecule,
      const emitDirtyState_t &_emitDirtyState) :
        QtMoleculeItem(_ObservedMolecule, QtMoleculeItem::NeedsMove, _emitDirtyState)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's atomcount.
   *
   */
  void internal_updateState()
  {
    setText(QString::number(ObservedMolecule->getAtomCount()));
  }

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::ATOMCOUNT; }
};



#endif /* QTMOLECULEITEM_ATOMCOUNT_HPP_ */
