/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeByOrderAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/MoleculeByOrderAction.hpp"

// and construct the stuff
#include "MoleculeByOrderAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */

molecule * SearchMoleculeByOrder(int molindex)
{
  molecule *mol = NULL;
  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  int i=0;
  if (molindex > 0) {
    std::vector<molecule *>::const_iterator iter = molecules.begin();
    for (;iter != molecules.end();++iter) {
      ++i;
      if (molindex == i)
        break;
    }
    mol = *iter;
  } else {
    std::vector<molecule *>::const_reverse_iterator iter = molecules.rbegin();
    for (;iter != molecules.rend();--iter) {
      --i;
      if (molindex == i)
        break;
    }
    mol = *iter;
  }

  return mol;
}

Action::state_ptr SelectionMoleculeByOrderAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  molecule *mol = SearchMoleculeByOrder(params.molindex);

  if (mol != NULL) {
    if (!World::getInstance().isSelected(mol)) {
      DoLog(1) && (Log() << Verbose(1) << "Selecting molecule " << mol->name << endl);
      World::getInstance().selectMolecule(mol);
      return Action::state_ptr(new SelectionMoleculeByOrderState(params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionMoleculeByOrderAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByOrderState *state = assert_cast<SelectionMoleculeByOrderState*>(_state.get());

  molecule *mol = SearchMoleculeByOrder(state->params.molindex);

  if (mol != NULL) {
    World::getInstance().unselectMolecule(mol);
    return Action::state_ptr(_state);
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionMoleculeByOrderAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByOrderState *state = assert_cast<SelectionMoleculeByOrderState*>(_state.get());

  molecule *mol = SearchMoleculeByOrder(state->params.molindex);

  if (mol != NULL) {
    World::getInstance().selectMolecule(mol);
    return Action::state_ptr(state);
  } else {
    return Action::failure;
  }
}

bool SelectionMoleculeByOrderAction::canUndo() {
  return true;
}

bool SelectionMoleculeByOrderAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
