/*
 * QTDialog.hpp
 *
 *  Created on: Jan 18, 2010
 *      Author: crueger
 */

#ifndef QTDIALOG_HPP_
#define QTDIALOG_HPP_

#include "UIElements/Dialog.hpp"
#include <QtGui/QDialog>
#include <QtGui/QFileDialog>

#include <boost/filesystem.hpp>

#include <map>
#include <set>
#include <vector>

class QBoxLayout;
class QLabel;
class QSpinBox;
class QDoubleSpinBox;
class QLineEdit;
class QListWidget;
class QComboBox;
class QDialogButtonBox;


// Forward declarations for plumbing
template<typename T> class QTQueryListPipe;
class BooleanQTQueryPipe;
class StringQTQueryPipe;
class StringsQTQueryPipe;
class IntQTQueryPipe;
class DoubleQTQueryPipe;
class DoublesQTQueryPipe;
class AtomQTQueryPipe;
class AtomsQTQueryPipe;
class MoleculeQTQueryPipe;
class MoleculesQTQueryPipe;
class EmptyQTQueryPipe;
class ElementQTQueryPipe;
class ElementsQTQueryPipe;
class VectorQTQueryPipe;
class VectorsQTQueryPipe;
class FileQTQueryPipe;

class QTDialog : public QDialog, public Dialog
{
  Q_OBJECT
public:
  QTDialog();
  virtual ~QTDialog();

  virtual void queryEmpty(const char*, std::string);
  virtual void queryBoolean(const char *, std::string = "");
  virtual void queryInt(const char *,std::string = "");
  virtual void queryInts(const char *,std::string = "");
  virtual void queryDouble(const char*,std::string = "");
  virtual void queryDoubles(const char*,std::string = "");
  virtual void queryString(const char*,std::string = "");
  virtual void queryStrings(const char*,std::string = "");
  virtual void queryAtom(const char*,std::string = "");
  virtual void queryAtoms(const char*,std::string = "");
  virtual void queryMolecule(const char*,std::string = "");
  virtual void queryMolecules(const char*,std::string = "");
  virtual void queryVector(const char*,bool,std::string = "");
  virtual void queryVectors(const char*,bool,std::string = "");
  virtual void queryBox(const char*, std::string = "");
  virtual void queryElement(const char*,std::string = "");
  virtual void queryElements(const char*,std::string = "");
  virtual void queryFile(const char*,std::string = "");

  virtual bool display();

  virtual void update();

protected:
  class IntQTQuery : public Dialog::IntQuery {
    public:
      IntQTQuery(std::string _title,QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~IntQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QSpinBox *inputBox;

      IntQTQueryPipe *pipe;
    };

  class IntsQTQuery : public Dialog::IntsQuery {
    public:
      IntsQTQuery(std::string _title,QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~IntsQTQuery();
      virtual bool handle();
      void IntegerEntered(const QString&);
      void IntegerSelected();
      void AddInteger();
      void RemoveInteger();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;

      QTQueryListPipe<int> *pipe;
    };

    class DoubleQTQuery : public Dialog::DoubleQuery {
    public:
      DoubleQTQuery(std::string title,QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~DoubleQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QDoubleSpinBox *inputBox;

      DoubleQTQueryPipe *pipe;
    };

    class DoublesQTQuery : public Dialog::DoublesQuery {
    public:
      DoublesQTQuery(std::string title,QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~DoublesQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QDoubleSpinBox *inputBox;

      QTQueryListPipe<double> *pipe;
    };

    class StringQTQuery : public Dialog::StringQuery {
    public:
      StringQTQuery(std::string _title, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~StringQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QLineEdit *inputBox;

      StringQTQueryPipe *pipe;
    };

    class StringsQTQuery : public Dialog::StringsQuery {
    public:
      StringsQTQuery(std::string _title, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~StringsQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QLineEdit *inputBox;

      QTQueryListPipe<std::string> *pipe;
    };

    class AtomQTQuery : public Dialog::AtomQuery {
    public:
      AtomQTQuery(std::string _title, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~AtomQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      AtomQTQueryPipe *pipe;
    };

    class AtomsQTQuery : public Dialog::AtomsQuery {
    public:
      AtomsQTQuery(std::string _title, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~AtomsQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      AtomsQTQueryPipe *pipe;
    };

    class MoleculeQTQuery : public Dialog::MoleculeQuery {
    public:
      MoleculeQTQuery(std::string _title, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~MoleculeQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      MoleculeQTQueryPipe *pipe;
    };

    class MoleculesQTQuery : public Dialog::MoleculesQuery {
    public:
      MoleculesQTQuery(std::string _title, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~MoleculesQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      MoleculesQTQueryPipe *pipe;
    };

    class VectorQTQuery : public Dialog::VectorQuery {
    public:
      VectorQTQuery(std::string title,bool _check,QBoxLayout *,QTDialog *);
      virtual ~VectorQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *mainLayout;
      QLabel *titleLabel;
      QBoxLayout *subLayout;
      QBoxLayout *coordLayout;
      QLabel *coordLabel;
      QDoubleSpinBox *coordInput;

      VectorQTQueryPipe *pipe;
    };

    class VectorsQTQuery : public Dialog::VectorsQuery {
    public:
      VectorsQTQuery(std::string title,bool _check,QBoxLayout *,QTDialog *);
      virtual ~VectorsQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *mainLayout;
      QLabel *titleLabel;
      QBoxLayout *subLayout;
      QBoxLayout *coordLayout;
      QLabel *coordLabel;
      QDoubleSpinBox *coordInput;

      VectorsQTQueryPipe *pipe;
    };

    class EmptyQTQuery : public Dialog::EmptyQuery {
    public:
      EmptyQTQuery(std::string _title, QBoxLayout *_parent, QTDialog *_dialog);
      virtual ~EmptyQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;

      EmptyQTQueryPipe *pipe;
    };

    class BooleanQTQuery : public Dialog::BooleanQuery {
    public:
      BooleanQTQuery(std::string _title, QBoxLayout *_parent, QTDialog *_dialog);
      virtual ~BooleanQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *booleanComboBox;

      BooleanQTQueryPipe *pipe;
    };

    class ElementQTQuery : public Dialog::ElementQuery {
    public:
      ElementQTQuery(std::string _title, QBoxLayout *_parent, QTDialog *_dialog);
      virtual ~ElementQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      ElementQTQueryPipe *pipe;
    };

    class ElementsQTQuery : public Dialog::ElementsQuery {
    public:
      ElementsQTQuery(std::string _title, QBoxLayout *_parent, QTDialog *_dialog);
      virtual ~ElementsQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      ElementsQTQueryPipe *pipe;
    };

    class FileQTQuery : public Dialog::FileQuery {
    public:
      FileQTQuery(std::string _title, QBoxLayout *_parent, QTDialog *_dialog);
      virtual ~FileQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *filenameLabel;
      QLineEdit *filenameLineEdit;
      QPushButton *filedialogButton;

      FileQTQueryPipe *pipe;
    };

private:
  QBoxLayout *mainLayout;
  QBoxLayout *inputLayout;
  QBoxLayout *buttonLayout;
  QDialogButtonBox *buttons;
};

// All kinds of plumbing for Queries
// Plumbing needs to be outside of the class where it is needed,
// since MOC doesn't like nested classes


template<typename T> class QTQueryListPipe : public QWidget {
  public:
    QTQueryListPipe(std::vector<T> *_content, QTDialog *_dialog, QLineEdit *_inputBox, QListWidget *_inputList, QPushButton *_AddButton, QPushButton *_RemoveButton);
    virtual ~QTQueryListPipe();
    void AddInteger();
    void RemoveInteger();
    void IntegerSelected();
    void IntegerEntered(const QString&);

  private:
    void AddValue(T item);
    void RemoveRow(int row);

    std::vector<T> *content;
    QTDialog *dialog;
    QLineEdit *inputBox;
    QListWidget *inputList;
    QPushButton *AddButton;
    QPushButton *RemoveButton;
};


class StringQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  StringQTQueryPipe(std::string *_content, QTDialog *_dialog);
  virtual ~StringQTQueryPipe();

public slots:
  void update(const QString&);

private:
  std::string *content;
  QTDialog *dialog;

};

class IntQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  IntQTQueryPipe(int *_content, QTDialog *_dialog);
  virtual ~IntQTQueryPipe();

public slots:
  void update(int);

private:
  int *content;
  QTDialog *dialog;

};


class DoubleQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  DoubleQTQueryPipe(double *_content, QTDialog *_dialog);
  virtual ~DoubleQTQueryPipe();

public slots:
  void update(double);

private:
  double *content;
  QTDialog *dialog;

};

class AtomQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  AtomQTQueryPipe(atom **_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~AtomQTQueryPipe();

public slots:
  void update(int);

private:
  atom **content;
  QTDialog *dialog;
  QComboBox *theBox;

};


class AtomsQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  AtomsQTQueryPipe(std::vector<atom *>*_content, QTDialog *_dialog, QListWidget *_theList);
  virtual ~AtomsQTQueryPipe();

public slots:
  void update();
  void add();
  void remove();

private:
  std::vector<atom *>*content;
  std::map<int, atom *> lookup;
  std::set<atom *> currentList;
  QTDialog *dialog;
  QListWidget *theList;

};

class MoleculeQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  MoleculeQTQueryPipe(molecule **_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~MoleculeQTQueryPipe();

public slots:
  void update(int);

private:
  molecule **content;
  QTDialog *dialog;
  QComboBox *theBox;

};

class MoleculesQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  MoleculesQTQueryPipe(std::vector<molecule *>*_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~MoleculesQTQueryPipe();

public slots:
  void update(int);

private:
  std::vector<molecule *>*content;
  QTDialog *dialog;
  QComboBox *theBox;

};

class VectorQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  VectorQTQueryPipe(Vector *_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~VectorQTQueryPipe();

public slots:
  void update();

private:
  Vector *content;
  QTDialog *dialog;
  QComboBox *theBox;
};

class VectorsQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  VectorsQTQueryPipe(std::vector<Vector>*_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~VectorsQTQueryPipe();

public slots:
  void update();

private:
  std::vector<Vector> *content;
  QTDialog *dialog;
  QComboBox *theBox;
};

class EmptyQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  EmptyQTQueryPipe(QTDialog *_dialog, QLabel *_textLabel);
  virtual ~EmptyQTQueryPipe();

public slots:
  void update();

private:
  QTDialog *dialog;
  QLabel *textLabel;
};

class BooleanQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  BooleanQTQueryPipe(const bool *_content, QTDialog *_dialog, QComboBox *_booleanComboBox);
  virtual ~BooleanQTQueryPipe();

public slots:
  void update();

private:
  const bool *content;
  QTDialog *dialog;
  QComboBox *booleanComboBox;
};

class ElementQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  ElementQTQueryPipe(const element **_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~ElementQTQueryPipe();

public slots:
  void update(int);

private:
  const element **content;
  QTDialog *dialog;
  QComboBox *theBox;
};

class ElementsQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  ElementsQTQueryPipe(std::vector<const element *>*_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~ElementsQTQueryPipe();

public slots:
  void update(int);

private:
  std::vector<const element *>*content;
  QTDialog *dialog;
  QComboBox *theBox;
};

class FileQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  FileQTQueryPipe(boost::filesystem::path *_content, QTDialog *_dialog, QLineEdit *_filenameLineEdit, QPushButton *_filedialogButton);
  virtual ~FileQTQueryPipe();

public slots:
  void update();
  void showFileDialog();

private:
  boost::filesystem::path *content;
  QTDialog *dialog;
  QLineEdit *filenameLineEdit;
  QPushButton *filedialogButton;
  QFileDialog *theFileDialog;
};

#endif /* QTDIALOG_HPP_ */
