/*
 * RepeatBoxAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/RepeatBoxAction.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "Matrix.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculePtrDescriptor.hpp"

const char WorldRepeatBoxAction::NAME[] = "repeat-box";

WorldRepeatBoxAction::WorldRepeatBoxAction() :
  Action(NAME)
{}

WorldRepeatBoxAction::~WorldRepeatBoxAction()
{}

Action::state_ptr WorldRepeatBoxAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  Vector Repeater;
  int count;
  const element ** Elements;
  molecule *mol = NULL;
  int j = 0;
  atom *Walker = NULL;
  MoleculeListClass *molecules = World::getInstance().getMolecules();

  dialog->queryVector(NAME, &Repeater, World::getInstance().getDomain(), false, MapOfActions::getInstance().getDescription(NAME));
  //dialog->queryMolecule("molecule-by-id", &mol,MapOfActions::getInstance().getDescription("molecule-by-id"));
  vector<molecule *> AllMolecules;
  if (mol != NULL) {
    DoLog(0) && (Log() << Verbose(0) << "Using molecule " << mol->name << "." << endl);
    AllMolecules = World::getInstance().getAllMolecules(MoleculeByPtr(mol));
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Using all molecules." << endl);
    AllMolecules = World::getInstance().getAllMolecules();
  }

  if(dialog->display()) {
    (cout << "Repeating box " << Repeater << " times for (x,y,z) axis." << endl);
    double * const cell_size = World::getInstance().getDomain();
    double *M_double = ReturnFullMatrixforSymmetric(cell_size);
    Matrix M = Matrix(M_double);
    delete[] M_double;
    Vector x,y;
    int n[NDIM];
    for (int axis = 0; axis < NDIM; axis++) {
      Repeater[axis] = floor(Repeater[axis]);
      if (Repeater[axis] < 1) {
        DoeLog(1) && (eLog()<< Verbose(1) << "Repetition factor must be greater than 1!" << endl);
        Repeater[axis] = 1;
      }
      cell_size[(abs(axis+1) == 2) ? 2 : ((abs(axis+2) == 3) ? 5 : 0)] *= Repeater[axis];
    }

    molecule *newmol = NULL;
    Vector ** vectors = NULL;
    for (n[0] = 0; n[0] < Repeater[0]; n[0]++) {
      y[0] = n[0];
      for (n[1] = 0; n[1] < Repeater[1]; n[1]++) {
        y[1] = n[1];
        for (n[2] = 0; n[2] < Repeater[2]; n[2]++) {
          y[2] = n[2];
          if ((n[0] == 0) && (n[1] == 0) && (n[2] == 0))
            continue;
          for (vector<molecule *>::iterator MolRunner = AllMolecules.begin(); MolRunner != AllMolecules.end(); ++MolRunner) {
            mol = *MolRunner;
            DoLog(1) && (Log() << Verbose(1) << "Current mol is " << mol->name << "." << endl);
            count = mol->getAtomCount();   // is changed becausing of adding, thus has to be stored away beforehand
            if (count != 0) {  // if there is more than none
              Elements = new const element *[count];
              vectors = new Vector *[count];
              j = 0;
              for(molecule::iterator AtomRunner = mol->begin(); AtomRunner != mol->end(); ++AtomRunner) {
                Elements[j] = (*AtomRunner)->type;
                vectors[j] = &(*AtomRunner)->x;
                j++;
              }
              if (count != j)
                DoeLog(1) && (eLog()<< Verbose(1) << "AtomCount " << count << " is not equal to number of atoms in molecule " << j << "!" << endl);
              x = y;
              x.MatrixMultiplication(M);
              newmol = World::getInstance().createMolecule();
              molecules->insert(newmol);
              for (int k=count;k--;) { // go through every atom of the original cell
                Walker = World::getInstance().createAtom(); // create a new body
                Walker->x = (*vectors[k]) + x;
                Walker->type = Elements[k];  // insert original element
                cout << "new atom is " << *Walker << endl;
                newmol->AddAtom(Walker);        // and add to the molecule (which increments ElementsInMolecule, AtomCount, ...)
              }
              // free memory
              delete[](Elements);
              delete[](vectors);
            } else {
              DoLog(1) && (Log() << Verbose(1) << "\t ... is empty." << endl);
            }
          }
        }
      }
    }
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr WorldRepeatBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldRepeatBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldRepeatBoxAction::canUndo() {
  return false;
}

bool WorldRepeatBoxAction::shouldUndo() {
  return false;
}

const string WorldRepeatBoxAction::getName() {
  return NAME;
}
