/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomOfMoleculeDescriptor.cpp
 *
 *  Created on: Dec 19, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "AtomOfMoleculeDescriptor.hpp"
#include "AtomOfMoleculeDescriptor_impl.hpp"

#include "Atom/atom.hpp"
#include "molecule.hpp"
#include "CodePatterns/Observer/ObservedContainer_impl.hpp"

using namespace std;


AtomOfMoleculeDescriptor_impl::AtomOfMoleculeDescriptor_impl(moleculeId_t _id) :
  id(_id)
{}

AtomOfMoleculeDescriptor_impl::~AtomOfMoleculeDescriptor_impl()
{}

bool AtomOfMoleculeDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom)
{
  if (atom.second->getMolecule() == NULL)
    return false;
  else
    return atom.second->getMolecule()->getId() == id;
}

AtomDescriptor AtomOfMolecule(moleculeId_t id)
{
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomOfMoleculeDescriptor_impl(id)));
}
