/*
 * CommandLineParser.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEPARSER_HPP_
#define COMMANDLINEPARSER_HPP_

#include <boost/program_options.hpp>

namespace po = boost::program_options;

#include "Patterns/Singleton.hpp"


class CommandLineParser : public Singleton<CommandLineParser, false> {
public:
  virtual ~CommandLineParser();

  // Parses the command line arguments in CommandLineParser::**argv with currently known options.
  void Run(int _argc, char **_argv);

  // Checks whether there have been any commands on the command line.
  bool isEmpty();

  /* boost's program_options are sorted into three categories:
   * -# generic options: option available to both command line and config
   * -# config options: only available in the config file
   * -# hidden options: options which the user is not shown on "help"
   */
  po::options_description generic;
  po::options_description config;
  po::options_description hidden;

protected:
  CommandLineParser();

private:
  /* The following program_options options_decriptions are used to
   * generate the various cases and call differently in Parse().
   */
  po::options_description cmdline_options;
  po::options_description config_file_options;
  po::options_description visible;

  po::variables_map vm;

  // Sets the options from the three cases.
  void setOptions(int _argc, char **_argv);

  // Parses all options from command line and config file
  void Parse();

  // argument counter and array passed on from main()
  int argc;
  char **argv;
};

#endif /* COMMANDLINEPARSER_HPP_ */
