/*
 * GLMoleculeObject_molecule.hpp
 *
 *  Created on: Mar 30, 2012
 *      Author: ankele
 */

#ifndef GLMOLECULEOBJECT_MOLECULE_HPP_
#define GLMOLECULEOBJECT_MOLECULE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/Observer/Observer.hpp"

#include "GLMoleculeObject_bond.hpp"

class atom;
class bond;
class molecule;

class GLMoleculeObject_molecule : public GLMoleculeObject, public Observer
{
  Q_OBJECT
public:
  GLMoleculeObject_molecule(QObject *parent, const molecule *molref);
  virtual ~GLMoleculeObject_molecule();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

private:

  const molecule *_molecule;
};



#endif /* GLMOLECULEOBJECT_MOLECULE_HPP_ */
