/*
 * DiscreteValue.hpp
 *
 *  Created on: Sep 28, 2011
 *      Author: heber
 */

#ifndef DISCRETEVALUE_HPP_
#define DISCRETEVALUE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "ValueInterface.hpp"

class DiscreteValueTest;

/** This class represents a discrete value.
 *
 */
template <class T>
class DiscreteValue : virtual public ValueInterface<T>
{
  //!> unit test needs to have access to internal values
  friend class DiscreteValueTest;
public:
  DiscreteValue();
  DiscreteValue(const std::vector<T> &_ValidValues);
  virtual ~DiscreteValue();

  // functions for ValueInterface
  bool isValid(const T &_value) const;
  const T & get() const;
  void set(const T & _value);

  // comfortable setter
  void operator=(const T &_value)
  { set(_value);  }

  // comparator
  bool operator==(const DiscreteValue<T> &_instance) const;
  bool operator!=(const DiscreteValue<T> &_instance) const
      { return !((*this)==(_instance)); }

  // setter/getter for valid values
  void appendValidValue(const T &_value);
  const std::vector<T> &getValidValues() const;

  // internal getter and setter
  bool isValidValue(const T &_value) const;
  void setValue(const T &_value);
  const T & getValue() const;
  const size_t getIndexOfValue() const { return value; }

private:
  const size_t findIndexOfValue(const T &_value) const;

private:
  //!> Typedef for the vector of valid values.
  typedef std::vector<T> ValidRange;

  //!> whether a value has been set or not
  bool ValueSet;

  //!> we only store the index within the \a ValidValues for the value
  size_t value;
  //!> list of valid values
  std::vector<T> ValidValues;
};

#include "DiscreteValue_impl.hpp"

#endif /* DISCRETEVALUE_HPP_ */
